/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.render;

import com.wildfire.main.WildfireGenderClient;
import com.wildfire.main.config.enums.Gender;
import com.wildfire.main.entitydata.Breasts;
import com.wildfire.main.entitydata.EntityConfig;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.main.uvs.UVLayout;
import com.wildfire.physics.BreastPhysics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.RenderStateDataKey;
import net.minecraft.class_10017;
import net.minecraft.class_11890;
import net.minecraft.class_1292;
import net.minecraft.class_1309;
import net.minecraft.class_1664;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class GenderRenderState {
    private static final RenderStateDataKey<@Nullable GenderRenderState> STATE = RenderStateDataKey.create(() -> "GenderRenderState");
    public final BreastState breasts = new BreastState();
    public final BreastPhysicsState leftBreastPhysics = new BreastPhysicsState();
    public final BreastPhysicsState rightBreastPhysics = new BreastPhysicsState();
    public float partialTicks;
    public Gender gender;
    public float bustSize;
    public boolean hasBreastPhysics;
    public float bounceMultiplier;
    public float floppyMultiplier;
    public boolean armorPhysicsOverride;
    public boolean showBreastsInArmor;
    public boolean hasJacketLayer;
    public boolean hasHolidayThemes;
    public UVLayout leftBreastUVLayout;
    public UVLayout rightBreastUVLayout;
    public UVLayout leftBreastOverlayUVLayout;
    public UVLayout rightBreastOverlayUVLayout;
    public UVLayout leftBreastArmorUVLayout;
    public UVLayout rightBreastArmorUVLayout;
    public boolean isBreathing;
    @Nullable
    public class_2561 nametag;

    public static void update(class_1309 entity, class_10017 state) {
        if (!EntityConfig.isSupportedEntity(entity)) {
            return;
        }
        EntityConfig config = EntityConfig.getEntity(entity);
        GenderRenderState modState = new GenderRenderState();
        modState.update(config, entity);
        state.setData(STATE, (Object)modState);
    }

    @Nullable
    public static GenderRenderState get(class_10017 state) {
        return (GenderRenderState)state.getData(STATE);
    }

    public void update(EntityConfig entityConfig, class_1309 entity) {
        this.breasts.update(entityConfig.getBreasts());
        this.leftBreastPhysics.update(entityConfig.getLeftBreastPhysics());
        this.rightBreastPhysics.update(entityConfig.getRightBreastPhysics());
        this.partialTicks = class_310.method_1551().method_61966().method_60637(true);
        this.gender = entityConfig.getGender();
        this.bustSize = entityConfig.getBustSize();
        this.hasBreastPhysics = entityConfig.hasBreastPhysics();
        this.bounceMultiplier = entityConfig.getBounceMultiplier();
        this.floppyMultiplier = entityConfig.getFloppiness();
        this.armorPhysicsOverride = entityConfig.getArmorPhysicsOverride();
        this.showBreastsInArmor = entityConfig.showBreastsInArmor();
        if (entity instanceof class_11890) {
            class_11890 playerLikeEntity = (class_11890)entity;
            this.hasJacketLayer = playerLikeEntity.method_74091(class_1664.field_7564);
        } else {
            boolean bl = this.hasJacketLayer = entityConfig instanceof PlayerConfig || entityConfig.hasJacketLayer();
        }
        if (entityConfig instanceof PlayerConfig) {
            PlayerConfig playerConfig = (PlayerConfig)entityConfig;
            this.hasHolidayThemes = playerConfig.hasHolidayThemes();
        } else {
            this.hasHolidayThemes = false;
        }
        this.leftBreastUVLayout = entityConfig.getLeftBreastUVLayout().copy();
        this.rightBreastUVLayout = entityConfig.getRightBreastUVLayout().copy();
        this.leftBreastOverlayUVLayout = entityConfig.getLeftBreastOverlayUVLayout().copy();
        this.rightBreastOverlayUVLayout = entityConfig.getRightBreastOverlayUVLayout().copy();
        this.leftBreastArmorUVLayout = entityConfig.getLeftBreastArmorUVLayout().copy();
        this.rightBreastArmorUVLayout = entityConfig.getRightBreastArmorUVLayout().copy();
        this.isBreathing = !entity.method_5869() || class_1292.method_5574((class_1309)entity) || entity.method_73183().method_8320(entity.method_24515()).method_27852(class_2246.field_10422);
        this.nametag = entity.method_31747() ? WildfireGenderClient.getNametag(entity.method_5667()) : null;
    }

    public static class BreastState {
        public float xOffset;
        public float yOffset;
        public float zOffset;
        public float cleavage;
        public boolean uniboob;

        public void update(Breasts breasts) {
            this.xOffset = breasts.getXOffset();
            this.yOffset = breasts.getYOffset();
            this.zOffset = breasts.getZOffset();
            this.cleavage = breasts.getCleavage();
            this.uniboob = breasts.isUniboob();
        }
    }

    public class BreastPhysicsState {
        private float prePositionY;
        private float positionY;
        private float prePositionX;
        private float positionX;
        private float preBounceRotation;
        private float bounceRotation;
        private float preBreastSize;
        private float breastSize;

        public void update(BreastPhysics breastPhysics) {
            this.prePositionY = breastPhysics.getPrePositionY();
            this.positionY = breastPhysics.getPositionY();
            this.prePositionX = breastPhysics.getPrePositionX();
            this.positionX = breastPhysics.getPositionX();
            this.preBounceRotation = breastPhysics.getPreBounceRotation();
            this.bounceRotation = breastPhysics.getBounceRotation();
            this.preBreastSize = breastPhysics.getPreBreastSize();
            this.breastSize = breastPhysics.getBreastSize();
        }

        public float getPositionY() {
            return class_3532.method_16439((float)GenderRenderState.this.partialTicks, (float)this.prePositionY, (float)this.positionY);
        }

        public float getPositionX() {
            return class_3532.method_16439((float)GenderRenderState.this.partialTicks, (float)this.prePositionX, (float)this.positionX);
        }

        public float getBounceRotation() {
            return class_3532.method_16439((float)GenderRenderState.this.partialTicks, (float)this.preBounceRotation, (float)this.bounceRotation);
        }

        public float getBreastSize() {
            return class_3532.method_16439((float)GenderRenderState.this.partialTicks, (float)this.preBreastSize, (float)this.breastSize);
        }
    }
}

