/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.render;

import com.google.common.base.Preconditions;
import com.wildfire.main.uvs.UVDirection;
import com.wildfire.main.uvs.UVLayout;
import com.wildfire.main.uvs.UVQuad;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public final class WildfireModelRenderer {
    private WildfireModelRenderer() {
        throw new UnsupportedOperationException();
    }

    public static class TexturedQuad {
        public final PositionTextureVertex[] vertexPositions;
        public final Vector3fc normal;
        public final float[] uvs;

        public TexturedQuad(float u1, float v1, float u2, float v2, float texWidth, float texHeight, UVDirection directionIn, PositionTextureVertex ... positionsIn) {
            Preconditions.checkArgument((positionsIn.length == 4 ? 1 : 0) != 0, (String)"Incorrect number of vertices; expected 4, got %s", (int)positionsIn.length);
            this.uvs = new float[]{u1, v1, u2, v2};
            this.vertexPositions = positionsIn;
            float f = 0.0f / texWidth;
            float f1 = 0.0f / texHeight;
            positionsIn[0] = positionsIn[0].withTexturePosition(u2 / texWidth - f, v1 / texHeight + f1);
            positionsIn[1] = positionsIn[1].withTexturePosition(u1 / texWidth + f, v1 / texHeight + f1);
            positionsIn[2] = positionsIn[2].withTexturePosition(u1 / texWidth + f, v2 / texHeight - f1);
            positionsIn[3] = positionsIn[3].withTexturePosition(u2 / texWidth - f, v2 / texHeight - f1);
            this.normal = directionIn.getUnitVector();
        }
    }

    public record PositionTextureVertex(float x, float y, float z, float u, float v) {
        public PositionTextureVertex withTexturePosition(float texU, float texV) {
            return new PositionTextureVertex(this.x, this.y, this.z, texU, texV);
        }
    }

    public static class BreastModelBox
    extends ModelBox {
        public BreastModelBox(int tW, int tH, float x, float y, float z, int dx, int dy, int dz, float delta, UVLayout dynamicUvLayouts) {
            super(tW, tH, x, y, z, dx, dy, dz, delta, 5, dynamicUvLayouts);
        }
    }

    public static class OverlayModelBox
    extends ModelBox {
        public OverlayModelBox(int tW, int tH, float x, float y, float z, int dx, int dy, int dz, float delta, UVLayout dynamicUvLayouts) {
            super(tW, tH, x, y, z, dx, dy, dz, delta, 5, dynamicUvLayouts);
        }
    }

    public static class ModelBox {
        public final TexturedQuad[] quads;
        public final float posX1;
        public final float posY1;
        public final float posZ1;
        public final float posX2;
        public final float posY2;
        public final float posZ2;
        protected final UVLayout dynamicUvLayouts;

        protected ModelBox(int tW, int tH, float x, float y, float z, int dx, int dy, int dz, float delta, int quads, UVLayout dynamicUvLayouts) {
            this.posX1 = x;
            this.posY1 = y;
            this.posZ1 = z;
            this.posX2 = x + (float)dx;
            this.posY2 = y + (float)dy;
            this.posZ2 = z + (float)dz;
            this.quads = new TexturedQuad[quads];
            this.dynamicUvLayouts = dynamicUvLayouts;
            float f = x + (float)dx;
            float f1 = y + (float)dy;
            float f2 = z + (float)dz;
            this.initQuads(tW, tH, dx, dy, dz, quads, new PositionTextureVertex(f += delta, y -= delta, z -= delta, 0.0f, 8.0f), new PositionTextureVertex(f, f1 += delta, z, 8.0f, 8.0f), new PositionTextureVertex(x -= delta, f1, z, 8.0f, 0.0f), new PositionTextureVertex(x, y, f2 += delta, 0.0f, 0.0f), new PositionTextureVertex(f, y, f2, 0.0f, 8.0f), new PositionTextureVertex(f, f1, f2, 8.0f, 8.0f), new PositionTextureVertex(x, f1, f2, 8.0f, 0.0f), new PositionTextureVertex(x, y, z, 0.0f, 0.0f));
        }

        protected void initQuads(int tW, int tH, int dx, int dy, int dz, int quads, PositionTextureVertex vertex, PositionTextureVertex vertex1, PositionTextureVertex vertex2, PositionTextureVertex vertex3, PositionTextureVertex vertex4, PositionTextureVertex vertex5, PositionTextureVertex vertex6, PositionTextureVertex vertex7) {
            PositionTextureVertex[][] faceVertices = new PositionTextureVertex[][]{{vertex4, vertex, vertex1, vertex5}, {vertex7, vertex3, vertex6, vertex2}, {vertex4, vertex3, vertex7, vertex}, {vertex1, vertex2, vertex6, vertex5}, {vertex, vertex7, vertex2, vertex1}, {vertex3, vertex4, vertex5, vertex6}};
            int i = 0;
            for (Map.Entry<UVDirection, UVQuad> entry : this.dynamicUvLayouts.getAllSides().entrySet()) {
                UVDirection direction = entry.getKey();
                UVQuad quad = entry.getValue();
                this.quads[i] = new TexturedQuad(quad.x1(), quad.y1(), quad.x2(), quad.y2(), tW, tH, direction, faceVertices[i][0], faceVertices[i][1], faceVertices[i][2], faceVertices[i][3]);
                ++i;
            }
        }
    }
}

