/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.render.debug;

import com.wildfire.api.IGenderArmor;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.entitydata.EntityConfig;
import com.wildfire.resources.GenderArmorResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_10192;
import net.minecraft.class_11630;
import net.minecraft.class_11632;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import net.minecraft.class_8144;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class GenderDebugHudEntry
implements class_11632 {
    private final class_2960 id;
    private final boolean clientPlayer;
    public static final class_2960 SELF = WildfireGender.id("self_gender_info");
    public static final class_2960 OTHER = WildfireGender.id("target_gender_info");
    private static final String PREFIX = String.valueOf(class_124.field_1080) + String.valueOf(class_124.field_1073) + "[" + String.valueOf(class_124.field_1076) + String.valueOf(class_124.field_1073) + "F" + String.valueOf(class_124.field_1068) + String.valueOf(class_124.field_1073) + "GM" + String.valueOf(class_124.field_1080) + String.valueOf(class_124.field_1073) + "]" + String.valueOf(class_124.field_1070) + String.valueOf(class_124.field_1073);

    public GenderDebugHudEntry(boolean clientPlayer) {
        this.clientPlayer = clientPlayer;
        this.id = clientPlayer ? SELF : OTHER;
    }

    public void method_72751(class_11630 lines, @Nullable class_1937 world, @Nullable class_2818 clientChunk, @Nullable class_2818 chunk) {
        class_1309 living;
        class_746 target;
        class_310 client = class_310.method_1551();
        Object object = target = this.clientPlayer ? client.field_1724 : client.field_1692;
        if (!(target instanceof class_1309) || !EntityConfig.isSupportedEntity(living = (class_1309)target)) {
            return;
        }
        EntityConfig config = EntityConfig.getEntity(living);
        ArrayList<String> info = new ArrayList<String>();
        info.add(PREFIX + " Gender Data");
        info.add("UUID: " + String.valueOf(target.method_5667()));
        info.addAll(config.getDebugInfo());
        this.addEquippedChestplate(info, config, living);
        lines.method_72744(this.id, info);
    }

    private void addEquippedChestplate(List<String> lines, EntityConfig config, class_1309 entity) {
        class_1799 equippedChestplate = entity.method_6118(class_1304.field_6174);
        class_10192 equippable = (class_10192)equippedChestplate.method_58694(class_9334.field_54196);
        class_5321 asset = (class_5321)class_8144.method_49077((Object)equippable, it -> it.comp_3176().orElse(null));
        if (asset == null) {
            return;
        }
        lines.add("");
        lines.add(PREFIX + " Equipped Chestplate");
        class_2960 id = asset.method_29177();
        IGenderArmor armorConfig = (IGenderArmor)class_8144.method_49078((Object)GenderArmorResourceManager.get(id), Function.identity(), (Object)IGenderArmor.DEFAULT);
        lines.add("Material: " + String.valueOf(id));
        if (!armorConfig.coversBreasts()) {
            lines.add("Covers breasts: false");
            return;
        }
        if (armorConfig.alwaysHidesBreasts()) {
            lines.add("Covers breasts: true");
            return;
        }
        lines.add("Physics resistance: " + armorConfig.physicsResistance());
        lines.add("Tightness: " + armorConfig.tightness());
        lines.add("Armor stands copy: " + armorConfig.armorStandsCopySettings());
        if (armorConfig.tightness() > 0.0f) {
            float renderedSize = config.getBustSize() * (1.0f - 0.15f * armorConfig.tightness());
            lines.add("Rendered breast size: " + renderedSize);
        }
    }
}

