/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.List;
import javax.annotation.Nonnegative;
import mezz.jei.common.Internal;
import mezz.jei.common.config.RecipeSorterStage;
import mezz.jei.common.gui.elements.ScalableDrawable;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import mezz.jei.gui.recipes.RecipeSortStateButton;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class RecipeOptionButtons {
    private static final int buttonSize = 16;
    private static final int buttonBorderSize = 1;
    private static final int borderSize = 5;
    private static final int overlapSize = 6;
    private final List<GuiIconToggleButton> buttons;
    private final ScalableDrawable backgroundTab;
    private ImmutableRect2i area;

    public RecipeOptionButtons(Runnable onValueChanged) {
        Textures textures = Internal.getTextures();
        RecipeSortStateButton bookmarksFirstButton = new RecipeSortStateButton(RecipeSorterStage.BOOKMARKED, textures.getBookmarksFirst(), textures.getBookmarksFirst(), (class_2561)class_2561.method_43471((String)"jei.tooltip.recipe.sort.bookmarks.first.disabled"), (class_2561)class_2561.method_43471((String)"jei.tooltip.recipe.sort.bookmarks.first.enabled"), onValueChanged);
        RecipeSortStateButton craftableFirstButton = new RecipeSortStateButton(RecipeSorterStage.CRAFTABLE, textures.getCraftableFirst(), textures.getCraftableFirst(), (class_2561)class_2561.method_43471((String)"jei.tooltip.recipe.sort.craftable.first.disabled"), (class_2561)class_2561.method_43471((String)"jei.tooltip.recipe.sort.craftable.first.enabled"), onValueChanged);
        this.buttons = List.of(bookmarksFirstButton, craftableFirstButton);
        this.backgroundTab = textures.getRecipeOptionsTab();
    }

    public void tick() {
        for (GuiIconToggleButton button : this.buttons) {
            button.tick();
        }
    }

    public void updateLayout(ImmutableRect2i recipeArea) {
        int width = 28;
        int height = 12 + this.buttons.size() * 16;
        int y = recipeArea.getY() + recipeArea.getHeight() - height;
        int x = recipeArea.getX() - width + 6;
        this.area = new ImmutableRect2i(x, y, width, height);
        int buttonX = x + 5 + 1;
        for (int i = 0; i < this.buttons.size(); ++i) {
            GuiIconToggleButton button = this.buttons.get(i);
            int buttonY = y + 5 + i * 16 + 1;
            button.updateBounds(new ImmutableRect2i(buttonX, buttonY, 16, 16));
        }
    }

    public ImmutableRect2i getArea() {
        return this.area;
    }

    public void draw(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.backgroundTab.draw(guiGraphics, this.area);
        for (GuiIconToggleButton button : this.buttons) {
            button.draw(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Nonnegative
    public int getWidth() {
        return Math.max(0, this.area.getWidth() - 6);
    }

    public IUserInputHandler createInputHandler() {
        List<IUserInputHandler> handlers = this.buttons.stream().map(GuiIconToggleButton::createInputHandler).toList();
        return new CombinedInputHandler("RecipeOptionButtons", handlers);
    }

    public void drawTooltips(class_332 guiGraphics, int mouseX, int mouseY) {
        for (GuiIconToggleButton button : this.buttons) {
            button.drawTooltips(guiGraphics, mouseX, mouseY);
        }
    }
}

