/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_10096;
import net.minecraft.class_10097;
import net.minecraft.class_10419;
import net.minecraft.class_10434;
import net.minecraft.class_10439;
import net.minecraft.class_10447;
import net.minecraft.class_1058;
import net.minecraft.class_10809;
import net.minecraft.class_10811;
import net.minecraft.class_10813;
import net.minecraft.class_10817;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1100;
import net.minecraft.class_11701;
import net.minecraft.class_11786;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5599;
import net.minecraft.class_5819;
import net.minecraft.class_7766;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_790;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import net.minecraft.class_801;
import net.minecraft.class_9824;
import net.minecraft.class_9826;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.duck.IModelHoldingBlockState;
import org.embeddedt.modernfix.dynamicresources.BlockStateSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicModelProvider {
    private final LoadingCache<class_2960, Optional<class_9824.class_10095>> loadedStateDefinitions = this.makeLoadingCache(this::loadBlockStateDefinition);
    private final LoadingCache<class_2960, Optional<class_1100>> loadedBlockModels = this.makeLoadingCache(this::loadBlockModel);
    private final LoadingCache<class_2960, Optional<class_10097.class_10814>> resolvedBlockModels = this.makeLoadingCache(this::resolveBlockModel);
    private final LoadingCache<class_2680, Optional<class_1087>> loadedBakedModels = this.makeLoadingCache(this::loadBakedModel);
    private final LoadingCache<class_2960, Optional<class_10434>> loadedClientItemProperties = this.makeLoadingCache(this::loadClientItemProperties);
    private final LoadingCache<class_2960, Optional<class_10439>> loadedItemModels = this.makeLoadingCache(this::loadItemModel);
    private final class_1087 missingModel;
    private final class_10097.class_10814 resolvedMissingModel;
    private final class_10439 missingItemModel;
    private final class_1100 unbakedMissingModel;
    private final Function<class_2960, class_2689<class_2248, class_2680>> stateMapper;
    private final class_3300 resourceManager;
    private final class_9826 textureGetter;
    private final class_5599 entityModelSet;
    private final class_801 itemModelGenerator;
    private final class_11786 skinRenderCache;
    private final class_11701 materialSet;
    private final Map<class_2680, class_1087> mrlModelOverrides = new ConcurrentHashMap<class_2680, class_1087>();
    private final Map<class_2960, class_10439> itemStackModelOverrides = new ConcurrentHashMap<class_2960, class_10439>();
    private final Map<class_2680, class_1087.class_10892> unbakedBlockStateModelOverrides = new ConcurrentHashMap<class_2680, class_1087.class_10892>();
    private final List<DynamicModelPlugin> pluginList = new ArrayList<DynamicModelPlugin>();
    private static final boolean DEBUG_DYNAMIC_MODEL_LOADING = Boolean.getBoolean("modernfix.debugDynamicModelLoading");
    public static WeakReference<DynamicModelProvider> currentReloadingModelProvider = new WeakReference<Object>(null);

    public DynamicModelProvider(class_3300 resourceManager, class_5599 entityModelSet, final class_7766.class_7767 preparations, class_11786 skinRenderCache, class_11701 materialSet) {
        this.unbakedMissingModel = class_10096.method_62629();
        this.entityModelSet = entityModelSet;
        this.skinRenderCache = skinRenderCache;
        this.materialSet = materialSet;
        final class_1058 missing = preparations.comp_1043();
        this.textureGetter = new class_9826(){

            @NotNull
            public class_1058 method_65739(class_4730 material, class_10813 modelDebugName) {
                class_1058 sprite = preparations.method_73022(material.method_24147());
                if (sprite != null) {
                    return sprite;
                }
                ModernFix.LOGGER.warn("Unable to find sprite '{}' referenced by model '{}'", (Object)material.method_24147(), (Object)modelDebugName.debugName());
                return missing;
            }

            @NotNull
            public class_1058 method_65740(String string, class_10813 modelDebugName) {
                return missing;
            }
        };
        this.stateMapper = class_10811.method_68013();
        this.resourceManager = resourceManager;
        this.itemModelGenerator = new class_801();
        this.resolvedMissingModel = new class_10097.class_10814(class_10096.field_53660, this.unbakedMissingModel, true);
        class_7775 missingModelBaker = new class_7775(){

            public class_10819 method_45872(class_2960 resourceLocation) {
                throw new IllegalStateException("Missing model should not have dependencies");
            }

            public class_9826 method_65732() {
                return DynamicModelProvider.this.textureGetter;
            }

            public <T> T method_68549(class_7775.class_10897<T> key) {
                return (T)key.compute((class_7775)this);
            }
        };
        class_10419 textureSlots = this.resolvedMissingModel.method_68045();
        final class_10817 quadCollection = this.resolvedMissingModel.method_68034(textureSlots, missingModelBaker, (class_3665)class_1086.field_5350);
        final class_1058 particleSprite = this.resolvedMissingModel.method_68033(textureSlots, missingModelBaker);
        this.missingModel = new class_1087(){

            public void method_68513(class_5819 random, List<class_10889> output) {
                output.add(new class_10889(){

                    public List<class_777> method_68509(@Nullable class_2350 direction) {
                        return quadCollection.method_68049(direction);
                    }

                    public boolean comp_3751() {
                        return DynamicModelProvider.this.resolvedMissingModel.method_68040();
                    }

                    public class_1058 comp_3752() {
                        return particleSprite;
                    }
                });
            }

            public class_1058 method_68511() {
                return particleSprite;
            }
        };
        this.missingItemModel = new class_10447(quadCollection.method_68048(), new class_10809(this.resolvedMissingModel.method_68042().method_24299(), particleSprite, this.resolvedMissingModel.method_68043()));
        try {
            Class.forName("net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class_1087 getMissingBakedModel() {
        return this.missingModel;
    }

    public class_10439 getMissingItemModel() {
        return this.missingItemModel;
    }

    public Map<class_2680, class_1087> getTopLevelEmulatedRegistry() {
        return new EmulatedRegistry<class_2680, class_1087>(class_2680.class, this.loadedBakedModels, BlockStateSet::instance, this.mrlModelOverrides);
    }

    public Map<class_2680, class_1087> getFastTopLevelEmulatedRegistry() {
        final Map<class_2680, class_1087> dynamicRegistry = this.getTopLevelEmulatedRegistry();
        return new ForwardingMap<class_2680, class_1087>(){

            protected Map<class_2680, class_1087> delegate() {
                return dynamicRegistry;
            }

            public class_1087 get(Object key) {
                IModelHoldingBlockState state;
                class_1087 result;
                if (key instanceof IModelHoldingBlockState && (result = (state = (IModelHoldingBlockState)key).mfix$getModel()) != null) {
                    return result;
                }
                result = dynamicRegistry.getOrDefault(key, DynamicModelProvider.this.getMissingBakedModel());
                if (key instanceof IModelHoldingBlockState) {
                    state = (IModelHoldingBlockState)key;
                    state.mfix$setModel(result);
                }
                return result;
            }
        };
    }

    public Map<class_2960, class_10439> getItemModelEmulatedRegistry() {
        return new EmulatedRegistry<class_2960, class_10439>(class_2960.class, this.loadedItemModels, () -> ((class_7922)class_7923.field_41178).method_10235(), this.itemStackModelOverrides);
    }

    public Map<class_2960, class_10434.class_10543> getItemPropertiesEmulatedRegistry() {
        return Maps.transformValues(new EmulatedRegistry<class_2960, class_10434>(class_2960.class, this.loadedClientItemProperties, () -> ((class_7922)class_7923.field_41178).method_10235(), Map.of()), class_10434::comp_3465);
    }

    private <K, V> LoadingCache<K, Optional<V>> makeLoadingCache(final Function<K, Optional<V>> loadingFunction) {
        return CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(8).softValues().build(new CacheLoader<K, Optional<V>>(this){

            public Optional<V> load(K key) {
                return (Optional)loadingFunction.apply(key);
            }
        });
    }

    private Optional<class_9824.class_10095> loadBlockStateDefinition(class_2960 location) {
        class_2689<class_2248, class_2680> stateDefinition = this.stateMapper.apply(location);
        if (stateDefinition == null) {
            return Optional.empty();
        }
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading blockstate definition '{}'", (Object)location);
        }
        List resources = this.resourceManager.method_14489(class_2960.method_60655((String)location.method_12836(), (String)("blockstates/" + location.method_12832() + ".json")));
        ArrayList<class_9824.class_10094> loadedDefinitions = new ArrayList<class_9824.class_10094>(resources.size());
        for (class_3298 resource : resources) {
            try {
                BufferedReader reader = resource.method_43039();
                try {
                    JsonObject jsonObject = class_3518.method_15255((Reader)reader);
                    class_790 blockModelDefinition = (class_790)((Pair)class_790.field_56928.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow()).getFirst();
                    loadedDefinitions.add(new class_9824.class_10094(resource.method_14480(), blockModelDefinition));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                ModernFix.LOGGER.error("Failed to load blockstate definition {} from pack '{}'", (Object)location, (Object)resource.method_14480(), (Object)e);
            }
        }
        HashMap<class_2680, class_1087.class_9979> loadedModels = new HashMap<class_2680, class_1087.class_9979>(class_9824.method_62627((class_2960)location, stateDefinition, loadedDefinitions).comp_3063());
        if (!this.pluginList.isEmpty()) {
            loadedModels.replaceAll((mrl, oldModel) -> {
                class_1087.class_9979 ubm = oldModel;
                for (DynamicModelPlugin plugin : this.pluginList) {
                    ubm = plugin.modifyBlockModelOnLoad((class_1087.class_9979)oldModel, (class_2680)mrl);
                }
                return ubm;
            });
        }
        return Optional.of(new class_9824.class_10095(loadedModels));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private class_1087 bakeModel(class_1087.class_9979 model, class_2680 mrl) {
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Baking model '{}'", (Object)mrl);
        }
        DynamicModelProvider dynamicModelProvider = this;
        synchronized (dynamicModelProvider) {
            model.method_62326(dep -> {});
            DynamicBaker modelBaker = new DynamicBaker(() -> ((class_2680)mrl).toString());
            for (DynamicModelPlugin plugin : this.pluginList) {
                model = plugin.modifyBlockModelBeforeBake(model, mrl, modelBaker);
            }
            class_1087 bakedModel = model.method_65542(mrl, (class_7775)modelBaker);
            for (DynamicModelPlugin plugin : this.pluginList) {
                bakedModel = plugin.modifyBlockModelAfterBake(bakedModel, model, mrl, modelBaker);
            }
            return bakedModel;
        }
    }

    private Optional<class_1087> loadBakedModel(class_2680 state) {
        class_1087 override = this.mrlModelOverrides.get(state);
        if (override != null) {
            return Optional.of(override);
        }
        Optional<class_1087.class_9979> unbakedModelOpt = Optional.ofNullable(this.unbakedBlockStateModelOverrides.get(state)).map(class_1087.class_10892::method_68515);
        if (unbakedModelOpt.isEmpty()) {
            Optional optLoadedModels = (Optional)this.loadedStateDefinitions.getUnchecked((Object)state.method_26204().method_40142().method_40237().method_29177());
            unbakedModelOpt = optLoadedModels.map(loadedModels -> (class_1087.class_9979)loadedModels.comp_3063().get(state));
        }
        return unbakedModelOpt.map(unbakedModel -> this.bakeModel((class_1087.class_9979)unbakedModel, state));
    }

    private Optional<class_1100> loadBlockModelDefault(class_2960 location) {
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading block model '{}'", (Object)location);
        }
        if (location.equals((Object)class_801.field_55273)) {
            return Optional.of(this.itemModelGenerator);
        }
        if (location.equals((Object)class_10096.field_53660)) {
            return Optional.of(this.unbakedMissingModel);
        }
        Optional resource = this.resourceManager.method_14486(class_2960.method_60655((String)location.method_12836(), (String)("models/" + location.method_12832() + ".json")));
        if (resource.isPresent()) {
            Optional<class_793> optional;
            block12: {
                BufferedReader reader = ((class_3298)resource.get()).method_43039();
                try {
                    class_793 blockModel = class_793.method_3437((Reader)reader);
                    optional = Optional.of(blockModel);
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        ModernFix.LOGGER.error("Failed to load block model {} from '{}'", (Object)location, (Object)((class_3298)resource.get()).method_14480(), (Object)e);
                        return Optional.empty();
                    }
                }
                ((Reader)reader).close();
            }
            return optional;
        }
        ModernFix.LOGGER.warn("Model '{}' does not exist in any resource packs", (Object)location);
        return Optional.empty();
    }

    private Optional<class_1100> loadBlockModel(class_2960 location) {
        Optional<class_1100> value = this.loadBlockModelDefault(location);
        for (DynamicModelPlugin plugin : this.pluginList) {
            value = plugin.modifyModelOnLoad(value, location);
        }
        return value;
    }

    private Optional<class_10097.class_10814> resolveBlockModel(class_2960 location) {
        Optional unbakedOpt = (Optional)this.loadedBlockModels.getUnchecked((Object)location);
        if (unbakedOpt.isEmpty()) {
            return Optional.empty();
        }
        class_10097.class_10814 wrapper = new class_10097.class_10814(location, (class_1100)unbakedOpt.get(), true);
        class_2960 parent = wrapper.method_68031().comp_3744();
        if (parent != null) {
            Optional resolvedParentOpt;
            try {
                resolvedParentOpt = (Optional)this.resolvedBlockModels.getUnchecked((Object)parent);
            }
            catch (Exception e) {
                ModernFix.LOGGER.error("Error while resolving model '{}'", (Object)location, (Object)e);
                return Optional.empty();
            }
            if (resolvedParentOpt.isPresent()) {
                wrapper.field_57004 = (class_10097.class_10814)resolvedParentOpt.get();
            }
        }
        return Optional.of(wrapper);
    }

    private Optional<class_10434> loadClientItemProperties(class_2960 location) {
        Optional resource;
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading client item '{}'", (Object)location);
        }
        if ((resource = this.resourceManager.method_14486(class_2960.method_60655((String)location.method_12836(), (String)("items/" + location.method_12832() + ".json")))).isPresent()) {
            Optional<class_10434> optional;
            block10: {
                BufferedReader reader = ((class_3298)resource.get()).method_43039();
                try {
                    class_10434 clientItem = (class_10434)class_10434.field_55327.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow();
                    optional = Optional.of(clientItem);
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        ModernFix.LOGGER.error("Failed to load client item {} from '{}'", (Object)location, (Object)((class_3298)resource.get()).method_14480(), (Object)e);
                        return Optional.empty();
                    }
                }
                ((Reader)reader).close();
            }
            return optional;
        }
        ModernFix.LOGGER.warn("Client item '{}' does not exist in any resource packs", (Object)location);
        return Optional.empty();
    }

    private Optional<class_10439> loadItemModel(class_2960 location) {
        class_10439 override;
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading item model '{}'", (Object)location);
        }
        if ((override = this.itemStackModelOverrides.get(location)) != null) {
            return Optional.of(override);
        }
        return ((Optional)this.loadedClientItemProperties.getUnchecked((Object)location)).map(clientItem -> {
            class_10439.class_10440 bakingContext = new class_10439.class_10440((class_7775)new DynamicBaker(() -> ((class_2960)location).toString()), this.entityModelSet, this.materialSet, this.skinRenderCache, this.missingItemModel, clientItem.comp_3610());
            return clientItem.comp_3385().method_65587(bakingContext);
        });
    }

    private static class EmulatedRegistry<K, V>
    implements Map<K, V> {
        private final LoadingCache<K, Optional<V>> realCache;
        private final Supplier<Set<K>> keys;
        private final Map<K, V> overrides;
        private final Class<K> keyClass;

        public EmulatedRegistry(Class<K> keyClass, LoadingCache<K, Optional<V>> realCache, Supplier<Set<K>> keys, Map<K, V> overrides) {
            this.keyClass = keyClass;
            this.realCache = realCache;
            this.keys = keys;
            this.overrides = overrides;
        }

        @Override
        public V get(Object key) {
            if (this.keyClass.isAssignableFrom(key.getClass())) {
                return ((Optional)this.realCache.getUnchecked(key)).orElse(null);
            }
            return null;
        }

        @Override
        public V getOrDefault(Object key, V defaultValue) {
            if (this.keyClass.isAssignableFrom(key.getClass())) {
                return ((Optional)this.realCache.getUnchecked(key)).orElse(defaultValue);
            }
            return defaultValue;
        }

        @Override
        public V put(K key, V value) {
            V oldValue = ((Optional)this.realCache.getUnchecked(key)).orElse(null);
            this.overrides.put(key, value);
            this.realCache.invalidate(key);
            return oldValue;
        }

        @Override
        public V remove(Object key) {
            this.overrides.remove(key);
            this.realCache.invalidate(key);
            return null;
        }

        @Override
        public void putAll(@NotNull Map<? extends K, ? extends V> m) {
            m.forEach(this::put);
        }

        @Override
        public void clear() {
            this.overrides.clear();
            this.realCache.invalidateAll();
        }

        @Override
        @NotNull
        public Set<K> keySet() {
            return this.keys.get();
        }

        @Override
        @NotNull
        public Collection<V> values() {
            return Collections.emptyList();
        }

        @Override
        public int size() {
            return this.keys.get().size();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.keys.get().contains(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        @NotNull
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return Iterators.transform(keys.get().iterator(), key -> new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return key;
                        }

                        @Override
                        public V getValue() {
                            return this.get(key);
                        }

                        @Override
                        public V setValue(V value) {
                            return this.put(key, value);
                        }
                    });
                }

                @Override
                public int size() {
                    return keys.get().size();
                }
            };
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            for (K location : this.keys.get()) {
                V existing;
                V replacement;
                boolean needsReplacement;
                try {
                    needsReplacement = function.apply(location, null) != null;
                }
                catch (Throwable e) {
                    needsReplacement = true;
                }
                if (!needsReplacement || (replacement = function.apply(location, existing = this.get(location))) == existing) continue;
                this.put(location, replacement);
            }
        }
    }

    private class DynamicBaker
    implements class_7775 {
        private final class_10813 modelDebugName;

        private DynamicBaker(class_10813 modelDebugName) {
            this.modelDebugName = modelDebugName;
        }

        public class_10819 method_45872(class_2960 location) {
            return (class_10819)((Optional)DynamicModelProvider.this.resolvedBlockModels.getUnchecked((Object)location)).orElse(DynamicModelProvider.this.resolvedMissingModel);
        }

        public class_9826 method_65732() {
            return DynamicModelProvider.this.textureGetter;
        }

        public <T> T method_68549(class_7775.class_10897<T> key) {
            return (T)key.compute((class_7775)this);
        }
    }

    public static interface DynamicModelPlugin {
        public Optional<class_1100> modifyModelOnLoad(Optional<class_1100> var1, class_2960 var2);

        public class_1087.class_9979 modifyBlockModelOnLoad(class_1087.class_9979 var1, class_2680 var2);

        public class_1100 modifyModelBeforeBake(class_1100 var1, class_2960 var2, class_3665 var3, class_7775 var4);

        public class_1087.class_9979 modifyBlockModelBeforeBake(class_1087.class_9979 var1, class_2680 var2, class_7775 var3);

        public class_1087 modifyBlockModelAfterBake(class_1087 var1, class_1087.class_9979 var2, class_2680 var3, class_7775 var4);
    }

    public static interface ModelManagerExtension {
        public DynamicModelProvider mfix$getModelProvider();
    }
}

