/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.config.hotkey;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.SerializableConfigEntry;
import su.plo.voice.api.client.config.hotkey.Hotkey;
import su.plo.voice.api.client.config.hotkey.Hotkeys;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.config.hotkey.HotkeyConfigEntry;
import su.plo.voice.client.config.hotkey.VoiceHotkey;
import su.plo.voice.client.event.key.KeyPressedEvent;

public final class ConfigHotkeys
implements Hotkeys,
SerializableConfigEntry {
    private Map<String, HotkeyConfigEntry> hotkeys = Maps.newHashMap();
    private final ListMultimap<String, HotkeyConfigEntry> categoryEntries = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
    private final Set<Hotkey.Key> pressedKeys = new HashSet<Hotkey.Key>();

    public ConfigHotkeys() {
        this.register("key.plasmovoice.proximity.ptt", (List<Hotkey.Key>)ImmutableList.of((Object)Hotkey.Type.KEYSYM.getOrCreate(342)), "hidden", true);
        this.register("key.plasmovoice.general.mute_microphone", (List<Hotkey.Key>)ImmutableList.of((Object)Hotkey.Type.KEYSYM.getOrCreate(77)), "key.plasmovoice.general", false);
        this.register("key.plasmovoice.general.disable_voice", (List<Hotkey.Key>)ImmutableList.of(), "key.plasmovoice.general", false);
        this.register("key.plasmovoice.general.action", (List<Hotkey.Key>)ImmutableList.of((Object)Hotkey.Type.MOUSE.getOrCreate(1)), "key.plasmovoice.general", false);
        this.register("key.plasmovoice.occlusion.toggle", (List<Hotkey.Key>)ImmutableList.of(), "key.plasmovoice.occlusion", false);
    }

    @Override
    @NotNull
    public synchronized Optional<Hotkey> getHotkey(@NotNull String name) {
        if (!this.hotkeys.containsKey(name)) {
            return Optional.empty();
        }
        return Optional.of((Hotkey)this.hotkeys.get(name).value());
    }

    public synchronized Optional<HotkeyConfigEntry> getConfigHotkey(@NotNull String name) {
        return Optional.ofNullable(this.hotkeys.get(name));
    }

    @Override
    @NotNull
    public synchronized Hotkey register(@NotNull String name, List<Hotkey.Key> keys2, @NotNull String category, boolean anyContext) {
        boolean hotkeyExists;
        VoiceHotkey hotkey = new VoiceHotkey(this, name, keys2, anyContext);
        if (this.categoryEntries.containsKey((Object)category) && (hotkeyExists = this.categoryEntries.values().stream().anyMatch(entry -> ((Hotkey)entry.value()).equals(hotkey)))) {
            throw new IllegalArgumentException("Hotkey with the same name is already exists");
        }
        HotkeyConfigEntry entry2 = new HotkeyConfigEntry(hotkey);
        this.categoryEntries.put((Object)category, (Object)entry2);
        this.hotkeys.put(name, entry2);
        return hotkey;
    }

    @Override
    public synchronized void resetPressedStates() {
        this.hotkeys.values().forEach(entry -> ((Hotkey)entry.value()).resetState());
    }

    @Override
    @NotNull
    public Map<String, Collection<Hotkey>> getCategories() {
        HashMap<String, Collection<Hotkey>> categories = new HashMap<String, Collection<Hotkey>>();
        this.categoryEntries.asMap().forEach((category, list) -> categories.put((String)category, list.stream().map(ConfigEntry::value).collect(Collectors.toList())));
        return categories;
    }

    @Override
    public synchronized void deserialize(Object object) {
        try {
            List serialized = (List)object;
            serialized.forEach(value -> {
                Map configKeyMap = (Map)value;
                String name = (String)configKeyMap.get("name");
                String category = (String)configKeyMap.get("category");
                List configKeys = (List)configKeyMap.get("keys");
                boolean anyContext = (Boolean)configKeyMap.get("any_context");
                ArrayList keys2 = new ArrayList();
                configKeys.forEach(serializedKey -> {
                    Map configKey = (Map)serializedKey;
                    Hotkey.Type keyType = Hotkey.Type.valueOf((String)configKey.get("type"));
                    int keyCode = ((Long)configKey.get("code")).intValue();
                    keys2.add(new Hotkey.Key(keyType, keyCode));
                });
                if (!this.hotkeys.containsKey(name)) {
                    this.register(name, (List<Hotkey.Key>)ImmutableList.of(), category, anyContext);
                }
                Optional<HotkeyConfigEntry> hotkeyEntry = this.categoryEntries.values().stream().filter(entry -> ((Hotkey)entry.value()).getName().equals(name)).findFirst();
                hotkeyEntry.ifPresent(entry -> entry.set(new VoiceHotkey(this, name, keys2, anyContext)));
            });
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public synchronized Object serialize() {
        ArrayList serialized = new ArrayList();
        this.categoryEntries.asMap().forEach((category, hotkeys) -> hotkeys.forEach(entry -> {
            if (entry.isDefault()) {
                return;
            }
            Hotkey hotkey = (Hotkey)entry.value();
            HashMap serializedHotkey = Maps.newHashMap();
            serializedHotkey.put("name", hotkey.getName());
            serializedHotkey.put("category", category);
            serializedHotkey.put("keys", hotkey.getKeys().stream().map(key -> {
                HashMap serializedKey = Maps.newHashMap();
                serializedKey.put("type", key.getType().name());
                serializedKey.put("code", key.getCode());
                return serializedKey;
            }).collect(Collectors.toList()));
            serializedHotkey.put("any_context", hotkey.isAnyContext());
            serialized.add(serializedHotkey);
        }));
        return serialized;
    }

    @EventSubscribe
    public void onKeyPressed(@NotNull KeyPressedEvent event) {
        if (event.getAction() == Hotkey.Action.UP) {
            this.pressedKeys.remove(event.getKey());
        } else {
            this.pressedKeys.add(event.getKey());
        }
        this.hotkeys.values().forEach(entry -> {
            if (((Hotkey)entry.value()).isAnyContext() || class_310.method_1551().field_1755 == null) {
                ((Hotkey)entry.value()).updateState(event.getAction());
            }
        });
    }

    public String toString() {
        return "ConfigHotkeys(hotkeys=" + String.valueOf(this.getHotkeys()) + ", categoryEntries=" + String.valueOf(this.getCategoryEntries()) + ", pressedKeys=" + String.valueOf(this.getPressedKeys()) + ")";
    }

    public Map<String, HotkeyConfigEntry> getHotkeys() {
        return this.hotkeys;
    }

    public void setHotkeys(Map<String, HotkeyConfigEntry> hotkeys) {
        this.hotkeys = hotkeys;
    }

    public ListMultimap<String, HotkeyConfigEntry> getCategoryEntries() {
        return this.categoryEntries;
    }

    public Set<Hotkey.Key> getPressedKeys() {
        return this.pressedKeys;
    }
}

